package com.agilex.healthcare.veteranappointment.datalayer.appointment;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.veteranappointment.domain.VARAppointmentRequest;
import com.agilex.healthcare.veteranappointment.domain.VARAppointmentRequestMessage;
import com.agilex.healthcare.veteranappointment.domain.VARAppointmentRequestMessages;
import com.agilex.healthcare.veteranappointment.domain.VARAppointmentRequests;

public interface AppointmentRequestDataLayer {

	VARAppointmentRequests fetchAppointmentRequestsByPatient(PatientIdentifiers identifiers, DateFilter filter);

	VARAppointmentRequests fetchAppointmentRequests(AppointmentRequestFilter filter);

    VARAppointmentRequest fetchAppointmentRequest(PatientIdentifiers identifiers, String appointmentRequestId);

    VARAppointmentRequest saveAppointmentRequest(VARAppointmentRequest appointmentRequest);

	void deleteAppointmentRequest(VARAppointmentRequest appointmentRequest);

    VARAppointmentRequestMessages fetchAppointmentRequestMessages(PatientIdentifiers identifiers, String appointRequestId);

    VARAppointmentRequestMessage saveAppointmentRequestMessage(PatientIdentifiers identifiers, VARAppointmentRequestMessage appointmentRequestMessage, boolean isProvider);

    VARAppointmentRequest updateMessageFlag(PatientIdentifiers identifiers, String appointmentRequestId, boolean isProvider);

    VARAppointmentRequest markAppointmentRequestIsSeenByProvider(PatientIdentifiers identifiers, String appointmentRequestId);

    int getSubmittedRequestCountByApptType(String patientId, DateFilter filter, String apptType, String locationId);
}
